﻿#pragma once
#include <Object.h>
#include "Material.h"
#include "StgSystem.h"

namespace SDX
{
class エフェクト : public Object
{
public:
	エフェクト( Image* image , double x , double y , double speed = 0):
			Object( new Point( x , y ) , new SpImage( image) )
	{}

	エフェクト( Anime* imageC , double x , double y , double speed = 0 , double aniSpeed = 1):
			Object( new Point( x , y ) , new SpAnime( imageC , aniSpeed) )
	{
		lifeTime = int(imageC->GetAnimeTime() / aniSpeed);
	}


	エフェクト( const IFont *font ,  Color rgb  , const char *str , double x , double y , double speed = 0):
			Object( new Point( x , y ) , new SpFont( font , rgb , str) )
	{}

	エフェクト( const BmpFrame *bmpFrame , double width , double height , double x , double y , double speed = 0):
			Object( new Point( x , y ) , new SpFrame( bmpFrame , width , height) )
	{}
};

class ボタン : public Object
{
public:
	ボタン( const BmpFrame *bmpFrame , double x , double y , double width , double height ):
			Object( new Rect( x , y , width , height ) , new SpFrame( bmpFrame , width , height) )
	{

	}
};

class 背景 : public Object
{
public:
	背景( double 頂点座標X , double 頂点座標Y , ImagePack &マップチップ , const char* ファイル名, int 幅, int 高さ):
		Object( new Point( 頂点座標X , 頂点座標Y ) , new SpMap( マップチップ , ファイル名, 幅, 高さ, 0) )
	{
		this->isOutCheck = false;
	}

	void Act()
	{
		Move(0,0.5);
	}
};

class システム表示 : public Object
{
private:
	int score = 0;
public:
	システム表示() :
		Object(new Point(0, 0), nullptr )
	{
		this->isOutCheck = false;
	}

	void Act()
	{
		if (StgSystem::score > score)
		{
			score += 56;
			if (StgSystem::score < score) score = StgSystem::score;
		}
	}


	void Draw() const
	{
		MSystem::テクスチャ[1]->DrawPart(  0, 0, 0, 0,150,600);
		MSystem::テクスチャ[1]->DrawPart(650, 0, 0, 0,150,600);

		//スコア表示
		MFont::赤絵.Draw(155, 5, Color::White, "SCORE");
		MFont::白絵.DrawExtend(160, 25, 2, 2,Color::White, "%d", score);

		MFont::赤絵.Draw(355, 5, Color::White, "HISCORE");
		MFont::白絵.DrawExtend(360, 25, 2, 2, Color::White , "%d", score);
		
		//ライフ表示
		MFrame::BMPフレーム[1].Draw(155, 57, StgSystem::maxShield + 16, 30);
		MFont::白絵.Draw(160, 55, Color::Aqua , "SHIELD");
		Drawing::Rect(164, 66, StgSystem::shield + 164, 75, Color::Red, true);

		//必殺ゲージ表示
		MFrame::BMPフレーム[2].Draw(155, 87, 100 + 16, 30);
		MFont::白絵.DrawExtend(160, 85,1,1 ,Color::Red, "HYPER");
		Drawing::Rect(164, 96, StgSystem::charge + 164, 105, Color::Red, true);

		//ボスライフゲージ
	
	}
};
}